//---------------------------------------------------------------------------------------------
// Torque Game Builder
// Copyright (C) GarageGames.com, Inc. EXCEPT NOT!
//---------------------------------------------------------------------------------------------

//Created by Aloshi.
//----------------------------------------------
//Some cool variables.
$Player = PlayerObject; //Defined in scene
$moveSpeed = "20"; //player move speed - changing it requires changing $collisionTime
$LastMovement = "Down"; //start out facing down
$collisionTime = 0.025; //time to test between collisions - higher = gaps, lower = vibrating more often
$Pref::timeManagerProcessInterval = 15; //limit to 60 fps or so
$diagonalSlow = 1.25; //number to divide by when calculating diagonal speed
$currentFrame = 0; //for character animation
$markerFrame = 0; //for target marker animation
$frameCount = 2; //number of frames
$frameReset = 1; //frame to set to when over $frameCount
$frameTime = 200; //time between frames
$battleFrameTime = 600; //time between target marker flashes (in battle)
$enableDebugKeys = 1; //enable map-editing keys, test battle keys, etc
$showPowerHitIndicator = 1; //show icon when you can do a power hit
$difficulty = 1; //what to divide all delays by - higher = harder
$zoomOutCutOff = "0.25"; //how far to zoom out (lower = further)
$zoomInCutOff = "1"; //leave at 1 (what to zoom back into when done zooming out)
$enableJoystick = 0; //enable joystick controls
$pref::Input::Deadzone = 0.3;  //joystick deadzone (might be a little high)
$worldEnemyMax = 10; //max enemies allowed at once
//----------------------------------------------

//For music datablocks
exec("./audioDatablocks.cs");

//Functions for key-presses are here, keys are assigned below in startGame()
exec("./Keys.cs");

//battle transitions
exec("./battleTransitions.cs");

//battle system
exec("./battle.cs");

//level editor
exec("./editor.cs");

//enemy system (in the world)
exec("./worldEnemies.cs");

//networking stuff (made just for fun, not very well-made - disabled)
//exec("./client.cs");
//exec("./server.cs");
//exec("./chat.cs");

//for random ideas that I have
exec("./randomStuff.cs");

//GUIs
if(!isObject(battleGui))
	exec("./ui/battleGui.gui");
if(!isObject(battleStatsGui))
	exec("./ui/battleStatsGui.gui");

//load all the imageMaps for animations
setUpImageMaps();

//---------------------------------------------------------------------------------------------
// startGame
// All game logic should be set up here. This will be called by the level builder when you
// select "Run Game" or by the startup process of your game to load the first level.
//---------------------------------------------------------------------------------------------
function startGame(%level)
{
		Canvas.setContent(mainScreenGui);
		Canvas.setCursor(DefaultCursor);
   
		new ActionMap(moveMap);   
		moveMap.push();
   
		moveMap.bind(keyboard, "left", moveLeft);
		moveMap.bind(keyboard, "right", moveRight);
		moveMap.bind(keyboard, "up", moveUp);
		moveMap.bind(keyboard, "down", moveDown);
		moveMap.bind(keyboard, "space", doPowerHit);
		moveMap.bind(keyboard, "tab", nextTarget);
		moveMap.bind(keyboard, "m", toggleMapZoom);
		moveMap.bind(keyboard, "t", showChat);
		if($enableDebugKeys)
		{
			moveMap.bind(keyboard, "q", practiceBattle);
			moveMap.bind(keyboard, "w", spin);
			moveMap.bind(keyboard, "e", spawnEnemy);
			moveMap.bind(keyboard, "z", togglePlacingGrass);
			moveMap.bind(keyboard, "a", togglePlacingWalls);
			moveMap.bind(keyboard, "d", togglePlacingText);
			moveMap.bind(keyboard, "x", toggleRemovingTiles);
			moveMap.bind(keyboard, "c", toggleCollision);
			moveMap.bind(keyboard, "v", toggleSpeedBoost);
			moveMap.bind(keyboard, "ctrl c", copyLevelToClipboard);
		}
		
		$enableDirectInput = true;
		activateDirectInput();
		
		if($enableJoystick)
		{
			enableJoystick();
			moveMap.bind(joystick0, "xaxis", joyXAxis);
			moveMap.bind(joystick0, "yaxis", joyYAxis);
			moveMap.bind(joystick0, "lpov", moveLeft);
			moveMap.bind(joystick0, "upov", moveUp);
			moveMap.bind(joystick0, "dpov", moveDown);
			moveMap.bind(joystick0, "rpov", moveRight);
			moveMap.bind(joystick0, "button2", doPowerHit);
			moveMap.bind(joystick0, "button6", nextTarget);
			moveMap.bind(joystick0, "button7", toggleMapZoom);
		}
		
		sceneWindow2D.loadLevel(%level);
}

function joyXAxis(%val)
{
	if($battleInProgress)
		return;
	
	if ($pref::Input::Deadzone < %val | - $pref::Input::Deadzone > %val)
	{
		if(%val > 0)
			moveRight(1);
		else
			moveLeft(1);
  }
  else
  {
		moveRight(0);
		moveLeft(0);
	}
}

function joyYAxis(%val)
{
	if($battleInProgress)
		return;
	
	if ($pref::Input::Deadzone < %val | - $pref::Input::Deadzone > %val)
	{
		if(%val > 0)
			moveDown(1);
		else
			moveUp(1);
  }
  else
  {
		moveUp(0);
		moveDown(0);
	}
}

//---------------------------------------------------------------------------------------------
// endGame
// Game cleanup should be done here.
//---------------------------------------------------------------------------------------------
function endGame()
{
   sceneWindow2D.endLevel();
   moveMap.pop();
   moveMap.delete();
   alxStopAll();
}

function PlayerObject::onLevelLoaded()
{
	sceneWindow2D.mount($Player, 0, 0, 0, 1); //mount camera so it follows player
	$Player.setCollisionActive(1, 1);
	$Player.setCollisionResponse("CLAMP");
	$Player.setSize("3.5 3.5"); //just a litttle smaller than the blocks so you can squeeze through them
	$Player.setCollisionMasks(BIT(2), BIT(2)); //collision
	$Player.setPosition("0 0");
	
	loadGrid("./levels/test.txt"); //load test level
	animationLoop(); //start animation loop
	
	//Start music
	$Music = alxPlay(GameMusic);
}

function loadGrid(%path)
{
	%file = new FileObject();
	if(!isFile(%path))
	{
		echo("error: file not found!");
		return;
	}
	
	%file.openForRead(%path);
	
	%row = 0;
	%col = 0;
	%startPoint = "0 0";
	
	while(!%file.isEOF())
	{
		%line = %file.readLine();
		createGridBlock(getWord(%line, 0), getWord(%line, 1) SPC getWord(%line, 2), getWords(%line, 3, getWordCount(%line) - 1));
	}
}

function createGridBlock(%block, %pos, %other)
{
	%layer = 1;
	
	if(%block $= "WallImageMap")
	{
		%layer = 2;
	}
	
	if(%block $= "Text")
	{
		%obj = new t2dTextObject() {
			size = "4 4";
			font = "Arial";
			textAlign = "Center";
			fontSizes = "80";
			textColor = getWords(%other, 0, 3);
			text = getWords(%other, 4, getWordCount(%other) - 1);
			layer = 1;
		};
		$Player.getSceneGraph().addToScene(%obj);
		%obj.setPosition(%pos);
		gridGroup.add(%obj);
		return;
	}
	
	%obj = new t2dStaticSprite()
	{
		scenegraph = $Player.scenegraph;
		size = "4 4";
		position = %pos;
		imageMap = %block; //%imageMap;
		layer = %layer;
	};
	
	if(%layer == 2)
	{
		%obj.setGraphGroup(2);
		%obj.setCollisionResponse(CLAMP);
		%obj.setCollisionActive(0, 1);
		%obj.setLayer(2);
		%obj.setImmovable(1);
		%obj.setPosition(%pos);
		%obj.setCollisionCallback(1);
	}
	
	gridGroup.add(%obj);
}

if(!isObject(gridGroup))
{
	new simGroup(gridGroup);
}

function t2dSceneGraph::onUpdateScene(%this)
{
	//if($battleInProgress)
	//	return;
	
	%vx = 0;
	%vy = 0;
	
	//9.9 and not $moveSpeed because 10 or more will make it do the vibrating thing
	//so use 9.9 for castCollision checks, multiply into $moveSpeed later if it passes (not foolproof, but ok)
	if($movingDown && !$againstDownWall)
	{
		%vy += 9.9;
	}
	if($movingUp && !$againstUpWall)
	{
		%vy -= 9.9;
	}
	if($movingLeft && !$againstLeftWall)
	{
		%vx -= 9.9;
	}
	if($movingRight && !$againstRightWall)
	{
		%vx += 9.9;
	}
	
	//you're going diagonal slow down omg speeder
	if(%vx != 0 && %vy != 0)
	{
		%vx = %vx / $diagonalSlow;
		%vy = %vy / $diagonalSlow;
	}
	
	if(!$doingSpecialAnimation)
	{
		if($moving[$lastMovement])
		{
			$Player.setImageMap("Player_" @ $lastMovement @ $currentFrame @ "ImageMap");
		}else{
			if($movingDown)
				$Player.setImageMap("Player_Down" @ $currentFrame @ "ImageMap");
			if($movingUp)
				$Player.setImageMap("Player_Up" @ $currentFrame @ "ImageMap");
			if($movingLeft)
				$Player.setImageMap("Player_Left" @ $currentFrame @ "ImageMap");
			if($movingRight)
				$Player.setImageMap("Player_Right" @ $currentFrame @ "ImageMap");
			
			//if($movingDown + $movingUp + $movingLeft + $movingRight == 0)
			//	$Player.setImageMap("Player_IdleImageMap");
		}
		
		if($movingUp && $movingRight)
			$Player.setImageMap("Player_UpRight" @ $currentFrame @ "ImageMap");
		if($movingUp && $movingLeft)
			$Player.setImageMap("Player_UpLeft" @ $currentFrame @ "ImageMap");
		if($movingDown && $movingRight)
			$Player.setImageMap("Player_DownRight" @ $currentFrame @ "ImageMap");
		if($movingDown && $movingLeft)
			$Player.setImageMap("Player_DownLeft" @ $currentFrame @ "ImageMap");
	}
	
	$Player.setLinearVelocity(%vx, %vy);
	//this checks if the player will collide at the speed hes going within the time specified
	%normal = $Player.castCollision($collisionTime);
	//get the collision normal x and y
	%normalX = getWord(%normal, 4);
  %normalY = getWord(%normal, 5);
   
   //if moving diagonally do overcomplicated checks so you dont get weird vibrating in corners
   if($movingUp + $movingDown + $movingRight + $movingLeft > 1)
   {
			%diagCheck = $Player.castCollisionList($collisionTime);
			if(getWordCount(%diagCheck)  > 2)
			{
				%vx = 0;
				%vy = 0;
			}
			if(getWordCount(%diagCheck) == 2)
			{
				%obj1 = getWord(%diagCheck, 0);
				%obj2 = getWord(%diagCheck, 1);
				if(%obj1.getPositionX() != %obj2.getPositionX() && %obj1.getPositionY() != %obj2.getPositionY())
				{
					%vx = 0;
					%vy = 0;
				}
			}
   }
   
   //collide left
   if (%normalX == 1 && %normalY == 0)
   {
      %vx = 0;
   }
   
   //collide right
   if (%normalX == -1 && %normalY == 0)
   {
      %vx = 0;
   }
   
   //collide down
   if (%normalX == 0 && %normalY == -1)
   {
      %vy = 0;
   }
   
   //collide up
   if (%normalY == 1)
   {
      %vy = 0;
   }
   
   //math is here to turn it into $moveSpeed again
   $Player.setLinearVelocity((%vx / 9.9) * $moveSpeed, (%vy / 9.9) * $moveSpeed);
   
   if($serverConnected)
   {
			if($lastVel !$= $Player.getLinearVelocity())
				commandToServer('ReceivePlayerStatus', $Player.getPositionX(), $Player.getPositionY(), $Player.getImageMap(), $Player.getLinearVelocityX(), $Player.getLinearVelocityY());
	 }
   
   $lastVel = $Player.getLinearVelocity();
   //$lastPos = $Player.getPosition();
   
		if($placingTiles)
			placeTile($tile);
		if($removingTiles)
			removeTile();
			
		if($placingText)
			updateEditorObjPosition($textObj);
}

function animationLoop()
{
	if($battleInProgress && isObject($targetMarker))
	{
		$targetMarker.setImageMap("marker" @ $markerFrame @ "ImageMap");
		$markerFrame++;
		if($markerFrame > 1)
			$markerFrame = 0;
		if(isEventPending($animationLoopSched))
			cancel($animationLoopSched);
		$animationLoopSched = schedule($battleFrameTime, 0, "animationLoop");
		return;
	}
	
	if(isEventPending($animationLoopSched))
		cancel($animationLoopSched);
	$animationLoopSched = schedule($frameTime, 0, "animationLoop");
	
	if($Player.getLinearVelocity() !$= "0.000000 0.000000")
	{
		$currentFrame++;
		if($currentFrame > $frameCount)
			$currentFrame = $frameReset;
	}else{
		$currentFrame = 1;
		$Player.setImageMap("Player_" @ $Player.getImageMap().dir @ "0ImageMap");
	}
}

function practiceBattle(%val)
{
	if(!%val)
		return;
	
	if(!$battleInProgress)
		startBattle("practiceEnemy practiceEnemy");
	else
		returnFromBattle1();
}

function togglePlacingGrass()
{
	$tile = "GrassImageMap";
	if($placingTiles)
		$placingTiles = 0;
	else
		$placingTiles = 1;
}

function togglePlacingWalls()
{
	$tile = "WallImageMap";
	if($placingTiles)
		$placingTiles = 0;
	else
		$placingTiles = 1;
}

function toggleRemovingTiles()
{
	if($removingTiles)
		$removingTiles = 0;
	else
		$removingTiles = 1;
}

function toggleCollision(%val)
{
	if(!%val)
		return;
		
	if($battleInProgress)
		return;
	
	if($Player.getCollisionMasks() $= "0 0")
		$Player.setCollisionMasks(BIT(2), BIT(2));
	else
		$Player.setCollisionMasks("0", "0");
}

function floatingMessage(%pos, %text, %size, %speed, %color)
{
	if(%color $= "")
		%color = "1 0.2 0.2 1";
	if(%size $= "")
		%size = "5 5";
	if(%speed $= "")
		%speed = -10;
	
	%obj = new t2dTextObject() {
		size = %size;
		font = "Arial";
		textAlign = "Center";
		fontSizes = "80";
		textColor = %color;
		text = %text;
	}; 
	$Player.getSceneGraph().addToScene(%obj);
	%obj.setPosition(%pos);
	%obj.setLinearVelocityY(%speed);
	%obj.setLinearVelocityX(getRandom(-10, 10) * 0.1);
	fadeText(%obj);
}

function fadeText(%obj)
{
	%textColor = getWords(%obj.textColor, 0, 2);
	%opacity = getWord(%obj.textColor, 3);
	%opacity -= 0.05;
	%obj.textColor = %textColor SPC %opacity;
	
	if(%opacity < 0)
	{
		%obj.delete();
		return;
	}
	
	schedule(40, 0, "fadeText", %obj);
}

$text = "By Aloshi";
function togglePlacingText(%val)
{
	if(!%val)
		return;
	if(!$placingText)
	{
		$textObj = placeText($text);
		$placingText = 1;
	}else{
		$placingText = 0;
	}
}

function toggleSpeedBoost(%val)
{
	if($moveSpeed == 20)
		$moveSpeed = 60;
	else
		$moveSpeed = 20;
}

function toggleMapZoom(%val)
{
	if($battleInProgress)
		return;
	
	if(%val)
	{
		$movingLeft = 0;
		$movingRight = 0;
		$movingUp = 0;
		$movingDown = 0;
		zoomOut();
	}else{
		zoomIn();
	}
}

function zoomOut()
{
	if($battleInProgress)
	{
		sceneWindow2D.setCurrentCameraZoom(1);
		return;
	}
	
	%zoom = sceneWindow2D.getCurrentCameraZoom();
	
	if(%zoom <= $zoomOutCutOff)
		return;
	
	%zoom -= 0.05;
	sceneWindow2D.setCurrentCameraZoom(%zoom);
	if(isEventPending($zoomSched))
		cancel($zoomSched);
	
	$zoomSched = schedule(25, 0, "zoomOut");
}

function zoomIn()
{
	if($battleInProgress)
	{
		sceneWindow2D.setCurrentCameraZoom(1);
		return;
	}
	
	%zoom = sceneWindow2D.getCurrentCameraZoom();
	
	if(%zoom >= $zoomInCutOff)
		return;
	
	%zoom += 0.05;
	sceneWindow2D.setCurrentCameraZoom(%zoom);
	if(isEventPending($zoomSched))
		cancel($zoomSched);
	
	$zoomSched = schedule(25, 0, "zoomIn");
}
